﻿/* Skript zur Demonstration von Pivotierungen
 * Als Benutzer SCOTT ausführen
 */

/* Pivotierung mit Gruppenfunktionen */
-- Abfrage mit einer Gruppierung über JOB und DEPTNO
select deptno, job, sum(sal) sum_sal
  from emp
 group by deptno, job
 order by deptno, job;
 
-- Erster Schritt: Gehälter auf Abteilungen verteilen
select job,
       decode(deptno, 10, sal) dept_10,
       decode(deptno, 20, sal) dept_20,
       decode(deptno, 30, sal) dept_30
  from emp;
  
-- Summierung der Gehälter, gruppiert nach Beruf
select job,
       sum(decode(deptno, 10, sal)) dept_10,
       sum(decode(deptno, 20, sal)) dept_20,
       sum(decode(deptno, 30, sal)) dept_30
  from emp
 group by job;
 
/* Pivotierung mit PIVOT-Klausel */  
-- Eine View zur Vorbereitung der Daten
create or replace view emp_pivot as
select job, deptno, sal
  from emp;

-- Verwendung der PIVOT - IN-Klausel
select *
  from emp_pivot
 pivot (sum(sal) for deptno in 
         (10 as dept_10, 
          20 as dept_20, 
          30 as dept_30));

-- Filterung der pivot-Tabelle
select *
  from emp_pivot
 pivot (sum(sal) for deptno in 
         (10 as dept_10, 
          20 as dept_20, 
          30 as dept_30))
 where dept_30 < 3500;
 
-- Versuch der Darstellung der Arbeitsweise der pivot-Klausel
select *
  from (select job,
               sum(decode(deptno, 10, sal)) dept_10,
               sum(decode(deptno, 20, sal)) dept_20,
               sum(decode(deptno, 30, sal)) dept_30
          from emp_pivot
         group by job)
 where dept_30 < 3500;


-- Die gleiche Abfrage mit einem globalen Spaltenalias
select *
  from emp_pivot
 pivot (sum(sal) as sum_sal,
       for deptno in 
         (10 as dept_10, 
          20 as dept_20, 
          30 as dept_30));

-- Beispiel für die Verwendung mehrerer Gruppenfunktionen
select *
  from emp_pivot
 pivot (sum(sal) as sum_sal, 
        avg(sal) as avg_sal, 
        max(sal) as max_sal
       for deptno in 
         (10 as dept_10), 
          20 as dept_20, 
          30 as dept_30);
          
/* Pivotierung mit XML-Klausel */
-- Verwendung der Klausel ANY
select *
  from emp_pivot
 pivot xml
       (sum(sal) as sum_sal
        for deptno in (ANY));

-- Verwendung einer Unterabfrage zur Definition der Pivotspalten
select *
  from emp_pivot
 pivot xml
       (sum(sal) as sum_sal,
        avg(sal) as avg_sal
        for deptno in (
          select deptno
            from dept))
 where job in ('CLERK', 'MANAGER');
 
/* UNPIVOTIERUNG mit Gruppenfunktionen */
 select level unpivot_row
   from dual
connect by level < 4;

-- Erster Schritt zurück: CROSS-JOIN zwischen der Pivot-Tabelle und den Zeilen
with pivot_table as (
      select job,
             sum(decode(deptno, 10, sal)) dept_10,
             sum(decode(deptno, 20, sal)) dept_20,
             sum(decode(deptno, 30, sal)) dept_30
        from emp
       group by job),
     unpivot_table as (
       select level unpivot_row
         from dual
      connect by level < 4)
select p.*, u.unpivot_row
  from pivot_table p
 cross join unpivot_table u;
 
-- Unpivotierung komplett:
with pivot_table as (
      select job,
             sum(decode(deptno, 10, sal)) dept_10,
             sum(decode(deptno, 20, sal)) dept_20,
             sum(decode(deptno, 30, sal)) dept_30
        from emp
       group by job),
     unpivot_table as (
       select level unpivot_row
         from dual
      connect by level < 4)
select p.job,
       case u.unpivot_row
       when 1 then 10
       when 2 then 20
       when 3 then 30 end deptno,
       case u.unpivot_row
       when 1 then dept_10
       when 2 then dept_20
       when 3 then dept_30 end sum_sal     
  from pivot_table p
 cross join unpivot_table u;
 
-- Variante zum Ausschluss der NULL-Werte
with pivot_table as (
      select job,
             sum(decode(deptno, 10, sal)) dept_10,
             sum(decode(deptno, 20, sal)) dept_20,
             sum(decode(deptno, 30, sal)) dept_30
        from emp
       group by job),
     unpivot_table as (
       select level unpivot_row
         from dual
      connect by level < 4)
select deptno, job, sum_sal
  from (select p.job,
               case u.unpivot_row
               when 1 then 10
               when 2 then 20
               when 3 then 30 end deptno,
               case u.unpivot_row
               when 1 then dept_10
               when 2 then dept_20
               when 3 then dept_30 end sum_sal     
          from pivot_table p
         cross join unpivot_table u)
 where sum_sal is not null
 order by deptno, job;
 
/* UNPIVOT mit Klausel */
with pivot_table as (
      select *
        from emp_pivot
       pivot (sum(sal) for deptno in 
               (10 as dept_10, 
                20 as dept_20, 
                30 as dept_30)))
select deptno, job, sum_sal
  from pivot_table
       unpivot exclude nulls (
         sum_sal for 
         deptno in (dept_10 as 10, 
                    dept_20 as 20, 
                    dept_30 as 30))
 order by deptno, job;
         
/* Sonstige Verwendung der UNPIVOT-Klausel */
with all_objects_data as (
        select owner,
               object_name,
               subobject_name,
               to_char(object_id) object_id,
               to_char(data_object_id) data_object_id,
               object_type,
               to_char(created) created,
               to_char(last_ddl_time) last_ddl_time,
               timestamp,
               status,
               temporary,
               generated,
               secondary,
               to_char(namespace) namespace,
               edition_name
          from all_objects
         where rownum = 1
        )
select column_name, column_value
  from all_objects_data
       unpivot include nulls(
	     column_value for
         column_name in 
          (owner, object_name, subobject_name, object_id,
           data_object_id, object_type, created, last_ddl_time,
           timestamp, status, temporary, generated,
           secondary, namespace, edition_name));